/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.core;

import com.chrisnewland.jitwatch.core.IJITListener;
import com.chrisnewland.jitwatch.core.JITEvent;
import com.chrisnewland.jitwatch.core.JITWatchConfig;
import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.JITDataModel;
import com.chrisnewland.jitwatch.util.ClassUtil;
import com.chrisnewland.jitwatch.util.ParseUtil;
import com.chrisnewland.jitwatch.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class HotSpotLogParser {
    private static final String TAG_TASK_QUEUED = "<task_queued compile_id";
    private static final String TAG_NMETHOD = "<nmethod";
    private static final String TAG_TASK = "<task compile_id";
    private static final String TAG_TASK_DONE = "<task_done";
    private static final String NATIVE_CODE_METHOD_MARK = "# {method}";
    private static final String LOADED = "[Loaded ";
    private static final String METHOD_START = "method='";
    private JITDataModel model;
    private boolean watching = false;
    private boolean inNativeCode = false;
    private StringBuilder nativeCodeBuilder = new StringBuilder();
    private IMetaMember currentMember = null;
    private IJITListener logListener = null;
    private long currentLineNumber;
    private JITWatchConfig config;

    public HotSpotLogParser(JITDataModel jITDataModel, JITWatchConfig jITWatchConfig, IJITListener iJITListener) {
        this.model = jITDataModel;
        this.logListener = iJITListener;
        this.config = jITWatchConfig;
    }

    private void mountAdditionalClasses() {
        for (String string : this.config.getClassLocations()) {
            URI uRI = new File(string).toURI();
            this.logListener.handleLogEntry("Adding classpath: " + uRI.toString());
            ClassUtil.addURIToClasspath(uRI);
        }
    }

    private void logEvent(JITEvent jITEvent) {
        if (this.logListener != null) {
            this.logListener.handleJITEvent(jITEvent);
        }
    }

    private void logError(String string) {
        if (this.logListener != null) {
            this.logListener.handleErrorEntry(string);
        }
    }

    public void watch(File file) throws IOException {
        this.mountAdditionalClasses();
        this.currentLineNumber = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        this.watching = true;
        while (this.watching) {
            if (string != null) {
                this.handleLine(string);
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    break;
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public void stop() {
        this.watching = false;
    }

    private void handleLine(String string) {
        string = string.replace("&apos;", "'");
        string = string.replace("&lt;", "<");
        string = string.replace("&gt;", ">");
        try {
            if (string.startsWith(TAG_TASK_QUEUED)) {
                if (this.inNativeCode) {
                    this.completeNativeCode();
                }
                this.handleMethod(string, EventType.QUEUE);
            } else if (string.startsWith(TAG_NMETHOD)) {
                if (this.inNativeCode) {
                    this.completeNativeCode();
                }
                this.handleMethod(string, EventType.NMETHOD);
            } else if (string.startsWith(TAG_TASK)) {
                if (this.inNativeCode) {
                    this.completeNativeCode();
                }
                this.handleMethod(string, EventType.TASK);
            } else if (string.startsWith(TAG_TASK_DONE)) {
                if (this.inNativeCode) {
                    this.completeNativeCode();
                }
                this.handleTaskDone(string);
            } else if (string.startsWith(LOADED)) {
                if (this.inNativeCode) {
                    this.completeNativeCode();
                }
                this.handleLoaded(string);
            } else if (string.contains(NATIVE_CODE_METHOD_MARK)) {
                String string2 = this.convertNativeCodeMethodName(string);
                this.currentMember = this.findMemberWithSignature(string2);
                this.inNativeCode = true;
                this.appendNativeCode(string);
            } else if (this.inNativeCode) {
                this.appendNativeCode(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ++this.currentLineNumber;
    }

    private void appendNativeCode(String string) {
        this.nativeCodeBuilder.append(string).append("\n");
    }

    private void completeNativeCode() {
        this.inNativeCode = false;
        if (this.currentMember != null) {
            this.currentMember.setNativeCode(this.nativeCodeBuilder.toString());
        }
        this.nativeCodeBuilder.delete(0, this.nativeCodeBuilder.length());
    }

    private void handleMethod(String string, EventType eventType) {
        boolean bl;
        Map<String, String> map = StringUtil.getLineAttributes(string);
        String string2 = StringUtil.getSubstringBetween(string, METHOD_START, "'");
        if (string2 != null && (bl = this.config.isAllowedPackage(string2 = string2.replace("/", ".")))) {
            map.remove("method");
            this.handleMethod(string2, map, eventType);
        }
    }

    private IMetaMember findMemberWithSignature(String string) {
        IMetaMember iMetaMember = null;
        String[] stringArray = null;
        try {
            stringArray = ParseUtil.parseLogSignature(string);
        }
        catch (Exception exception) {
            this.logError(exception.getMessage());
        }
        if (stringArray != null) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string3 != null) {
                iMetaMember = this.model.findMetaMember(string2, string3);
            }
        } else {
            this.logError("Could not parse line " + this.currentLineNumber + " : " + string);
        }
        return iMetaMember;
    }

    private void handleMethod(String string, Map<String, String> map, EventType eventType) {
        IMetaMember iMetaMember = this.findMemberWithSignature(string);
        String string2 = map.get("stamp");
        long l = (long)(Double.parseDouble(string2) * 1000.0);
        if (iMetaMember != null) {
            switch (eventType) {
                case QUEUE: {
                    iMetaMember.setQueuedAttributes(map);
                    JITEvent jITEvent = new JITEvent(l, false, iMetaMember.toString());
                    this.model.addEvent(jITEvent);
                    this.logEvent(jITEvent);
                    break;
                }
                case NMETHOD: {
                    iMetaMember.setCompiledAttributes(map);
                    iMetaMember.getMetaClass().incCompiledMethodCount();
                    this.model.updateStats(iMetaMember);
                    JITEvent jITEvent = new JITEvent(l, true, iMetaMember.toString());
                    this.model.addEvent(jITEvent);
                    this.logEvent(jITEvent);
                    break;
                }
                case TASK: {
                    iMetaMember.addCompiledAttributes(map);
                    this.currentMember = iMetaMember;
                }
            }
        }
    }

    private void handleTaskDone(String string) {
        Map<String, String> map = StringUtil.getLineAttributes(string);
        if (map.containsKey("nmsize")) {
            long l = Long.parseLong(map.get("nmsize"));
            this.model.addNativeBytes(l);
        }
        if (this.currentMember != null) {
            this.currentMember.addCompiledAttributes(map);
        }
    }

    private void handleLoaded(String string) {
        String string2 = StringUtil.getSubstringBetween(string, LOADED, " ");
        if (string2 != null) {
            String string3;
            String string4;
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = "";
                string3 = string2;
            }
            boolean bl = this.config.isAllowedPackage(string4);
            if (bl) {
                Class<?> clazz = null;
                try {
                    clazz = ClassUtil.loadClassWithoutInitialising(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logError("ClassNotFoundException: " + string2);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.logError("NoClassDefFoundError: " + string2);
                }
                this.model.buildMetaClass(string4, string3, clazz);
            }
        }
    }

    public String convertNativeCodeMethodName(String string) {
        String string2;
        int n;
        int n2 = (string = string.replace("'", "")).indexOf(NATIVE_CODE_METHOD_MARK);
        if (n2 != -1) {
            string = string.substring(n2 + NATIVE_CODE_METHOD_MARK.length());
            string = string.trim();
        }
        if ((n = string.indexOf(string2 = " in ")) != -1) {
            string = string.substring(n + string2.length()) + " " + string.substring(0, n);
        }
        string = string.replaceAll("/", ".");
        return string;
    }

    static enum EventType {
        QUEUE,
        NMETHOD,
        TASK;

    }
}

