/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.core;

import com.chrisnewland.jitwatch.util.StringUtil;

public class JITEvent {
    private long stamp;
    private boolean isCompile;
    private String methodSignature;
    private String stampString;

    public JITEvent(long l, boolean bl, String string) {
        this.stamp = l;
        this.isCompile = bl;
        this.methodSignature = string;
        this.stampString = StringUtil.formatTimestamp(l, true);
    }

    public long getStamp() {
        return this.stamp;
    }

    public boolean isCompile() {
        return this.isCompile;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.stampString);
        if (this.isCompile) {
            stringBuilder.append("  Compiled: ");
        } else {
            stringBuilder.append("    Queued: ");
        }
        stringBuilder.append(this.methodSignature);
        return stringBuilder.toString();
    }
}

