/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.core;

import com.chrisnewland.jitwatch.core.IJITListener;
import com.chrisnewland.jitwatch.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class JITWatchConfig {
    private static final String PROPERTIES_FILENAME = "jitwatch.properties";
    private static final String KEY_ALLOWED_PACKAGES = "PackageFilter";
    private static final String KEY_SOURCE_LOCATIONS = "Sources";
    private static final String KEY_CLASS_LOCATIONS = "Classes";
    private IJITListener logListener;
    private List<String> allowedPackages = new ArrayList<String>();
    private List<String> sourceLocations = new ArrayList<String>();
    private List<String> classLocations = new ArrayList<String>();

    public JITWatchConfig(IJITListener iJITListener) {
        this.logListener = iJITListener;
        this.loadConfig();
    }

    private void loadConfig() {
        Object object;
        Object object2;
        Properties properties = new Properties();
        try {
            object2 = new FileReader(this.getConfigFile());
            object = null;
            try {
                properties.load((Reader)object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStreamReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStreamReader)object2).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.logListener.handleErrorEntry(iOException.toString());
        }
        object2 = (String)properties.get(KEY_ALLOWED_PACKAGES);
        object = (String)properties.get(KEY_CLASS_LOCATIONS);
        String string = (String)properties.get(KEY_SOURCE_LOCATIONS);
        if (object2 != null && ((String)object2).trim().length() > 0) {
            this.allowedPackages = StringUtil.textToList((String)object2, ",");
        }
        if (object != null && ((String)object).trim().length() > 0) {
            this.classLocations = StringUtil.textToList((String)object, ",");
        }
        if (string != null && string.trim().length() > 0) {
            this.sourceLocations = StringUtil.textToList(string, ",");
        }
    }

    public void saveConfig() {
        Properties properties = new Properties();
        properties.put(KEY_ALLOWED_PACKAGES, StringUtil.listToText(this.allowedPackages, ","));
        properties.put(KEY_SOURCE_LOCATIONS, StringUtil.listToText(this.sourceLocations, ","));
        properties.put(KEY_CLASS_LOCATIONS, StringUtil.listToText(this.classLocations, ","));
        try (FileWriter fileWriter = new FileWriter(this.getConfigFile());){
            properties.store(fileWriter, null);
        }
        catch (IOException iOException) {
            this.logListener.handleErrorEntry(iOException.toString());
        }
    }

    private File getConfigFile() {
        return new File(System.getProperty("user.dir"), PROPERTIES_FILENAME);
    }

    public boolean isAllowedPackage(String string) {
        return this.allowedPackages.size() == 0 || this.checkPackage(string);
    }

    private boolean checkPackage(String string) {
        for (String string2 : this.allowedPackages) {
            if (!string2.equals(string) && !string.startsWith(string2 + ".")) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllowedPackages() {
        return Collections.unmodifiableList(this.allowedPackages);
    }

    public List<String> getClassLocations() {
        return Collections.unmodifiableList(this.classLocations);
    }

    public List<String> getSourceLocations() {
        return Collections.unmodifiableList(this.sourceLocations);
    }

    public void setAllowedPackages(List<String> list) {
        this.allowedPackages = list;
    }

    public void setSourceLocations(List<String> list) {
        this.sourceLocations = list;
    }

    public void setClassLocations(List<String> list) {
        this.classLocations = list;
    }
}

