/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.histo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Histo {
    private Map<Long, Integer> bucketMap = new HashMap<Long, Integer>();
    private List<Long> values = new ArrayList<Long>();
    private long lastTime = 0L;
    private int maxCount = 0;
    private long resolution = 1L;

    public Histo() {
    }

    public Histo(long l) {
        this.resolution = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(long l) {
        List<Long> list = this.values;
        synchronized (list) {
            this.values.add(l);
        }
        if (this.resolution > 1L) {
            l = l / this.resolution * this.resolution;
        }
        int n = 0;
        n = this.bucketMap.containsKey(l) ? this.bucketMap.get(l) + 1 : 1;
        this.bucketMap.put(l, n);
        if (n > this.maxCount) {
            this.maxCount = n;
        }
        if (l > this.lastTime) {
            this.lastTime = l;
        }
    }

    public void clear() {
        this.bucketMap.clear();
        this.lastTime = 0L;
        this.maxCount = 0;
    }

    public List<Map.Entry<Long, Integer>> getSortedData() {
        ArrayList<Map.Entry<Long, Integer>> arrayList = new ArrayList<Map.Entry<Long, Integer>>(this.bucketMap.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> entry, Map.Entry<Long, Integer> entry2) {
                return entry.getValue().compareTo(entry2.getValue());
            }
        });
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPercentile(int n) {
        long l = 0L;
        ArrayList<Long> arrayList = null;
        List<Long> list = this.values;
        synchronized (list) {
            arrayList = new ArrayList<Long>(this.values);
        }
        Collections.sort(arrayList);
        int n2 = arrayList.size();
        if (n >= 100) {
            l = (Long)arrayList.get(n2 - 1);
        } else if (n <= 0) {
            l = 0L;
        } else {
            double d = 0.5 + (double)n / 100.0 * (double)n2;
            int n3 = (int)Math.round(d) - 1;
            l = (Long)arrayList.get(n3);
        }
        return l;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

