/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.MetaClass;
import com.chrisnewland.jitwatch.model.MetaConstructor;
import com.chrisnewland.jitwatch.model.MetaPackage;
import com.chrisnewland.jitwatch.util.ParseUtil;
import com.chrisnewland.jitwatch.util.StringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMetaMember
implements IMetaMember {
    protected MetaClass methodClass;
    protected String nativeCode = null;
    protected boolean isQueued = false;
    protected boolean isCompiled = false;
    protected Map<String, String> queuedAttributes = new ConcurrentHashMap<String, String>();
    protected Map<String, String> compiledAttributes = new ConcurrentHashMap<String, String>();
    protected int modifier;
    protected String memberName;
    protected Class<?> returnType;
    protected Class<?>[] paramTypes;
    private static final String anyChars = "(.*)";
    private static final String spaceZeroOrMore = "( )*";
    private static final String spaceOneOrMore = "( )+";
    private static final String paramName = "([0-9a-zA-Z_]+)";
    private static final String regexPackage = "([0-9a-zA-Z_\\.]*)";

    @Override
    public List<String> getQueuedAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.queuedAttributes.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public MetaClass getMetaClass() {
        return this.methodClass;
    }

    @Override
    public String getQueuedAttribute(String string) {
        return this.queuedAttributes.get(string);
    }

    @Override
    public List<String> getCompiledAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.compiledAttributes.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public String getCompiledAttribute(String string) {
        return this.compiledAttributes.get(string);
    }

    @Override
    public void addCompiledAttribute(String string, String string2) {
        this.compiledAttributes.put(string, string2);
    }

    @Override
    public void setQueuedAttributes(Map<String, String> map) {
        this.isQueued = true;
        this.queuedAttributes = map;
    }

    @Override
    public boolean isQueued() {
        return this.isQueued;
    }

    @Override
    public void setCompiledAttributes(Map<String, String> map) {
        this.isCompiled = true;
        this.isQueued = false;
        this.compiledAttributes = map;
    }

    @Override
    public void addCompiledAttributes(Map<String, String> map) {
        this.compiledAttributes.putAll(map);
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    public String toStringUnqualifiedMethodName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(this.modifier)).append(' ');
        if (this.returnType != null) {
            stringBuilder.append(AbstractMetaMember.expandParam(this.returnType.getName())).append(' ');
        }
        stringBuilder.append(this.memberName);
        stringBuilder.append('(');
        if (this.paramTypes.length > 0) {
            for (Class<?> clazz : this.paramTypes) {
                stringBuilder.append(AbstractMetaMember.expandParam(clazz.getName())).append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(String string) {
        String string2 = this.toString();
        for (String string3 : MODIFIERS) {
            string2 = string2.replace(string3 + " ", "");
        }
        return string2.equals(string);
    }

    @Override
    public String getNativeCode() {
        return this.nativeCode;
    }

    @Override
    public void setNativeCode(String string) {
        this.nativeCode = string;
    }

    @Override
    public String getSignatureRegEx() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("^");
        stringBuilder.append(anyChars);
        String string = Modifier.toString(this.modifier);
        if (string.length() > 0) {
            stringBuilder.append(string).append(' ');
        }
        if (this.returnType != null) {
            Class<?>[] classArray = AbstractMetaMember.expandParamRegEx(this.returnType.getName());
            stringBuilder.append((String)classArray);
            stringBuilder.append(' ');
        }
        if (this instanceof MetaConstructor) {
            stringBuilder.append(regexPackage);
            stringBuilder.append(StringUtil.makeUnqualified(this.memberName));
        } else {
            stringBuilder.append(this.memberName);
        }
        stringBuilder.append("\\(");
        if (this.paramTypes.length > 0) {
            for (Class<?> clazz : this.paramTypes) {
                stringBuilder.append(spaceZeroOrMore);
                String string2 = AbstractMetaMember.expandParamRegEx(clazz.getName());
                stringBuilder.append(string2);
                stringBuilder.append(spaceOneOrMore);
                stringBuilder.append(paramName);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(spaceZeroOrMore);
        stringBuilder.append("\\)");
        stringBuilder.append(anyChars);
        stringBuilder.append("$");
        return stringBuilder.toString();
    }

    public static String expandParam(String string) {
        if (string.charAt(0) == '[') {
            string = ParseUtil.expandParameterType(string);
        }
        if (string.contains(".")) {
            string = StringUtil.makeUnqualified(string);
        }
        return string;
    }

    public static String expandParamRegEx(String string) {
        if (string.charAt(0) == '[') {
            string = ParseUtil.expandParameterType(string);
            string = string.replace("[", "\\[").replace("]", "\\]");
        }
        if (string.contains(".")) {
            string = regexPackage + StringUtil.makeUnqualified(string);
        }
        return string;
    }

    @Override
    public List<String> getTreePath() {
        MetaClass metaClass = this.getMetaClass();
        MetaPackage metaPackage = metaClass.getPackage();
        List<String> list = metaPackage.getPackageComponents();
        list.add(metaClass.getName());
        return list;
    }
}

