/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.core.JITEvent;
import com.chrisnewland.jitwatch.core.JITStats;
import com.chrisnewland.jitwatch.model.AbstractMetaMember;
import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.MetaClass;
import com.chrisnewland.jitwatch.model.MetaConstructor;
import com.chrisnewland.jitwatch.model.MetaMethod;
import com.chrisnewland.jitwatch.model.MetaPackage;
import com.chrisnewland.jitwatch.model.PackageManager;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class JITDataModel {
    private PackageManager pm;
    private JITStats stats;
    private List<JITEvent> jitEvents = new ArrayList<JITEvent>();

    public JITDataModel() {
        this.pm = new PackageManager();
        this.stats = new JITStats();
    }

    public void reset() {
        this.pm.clear();
        this.stats.reset();
        this.jitEvents.clear();
    }

    public PackageManager getPackageManager() {
        return this.pm;
    }

    public JITStats getJITStats() {
        return this.stats;
    }

    public synchronized void addEvent(JITEvent jITEvent) {
        this.jitEvents.add(jITEvent);
    }

    public synchronized List<JITEvent> getEventListCopy() {
        ArrayList<JITEvent> arrayList = new ArrayList<JITEvent>(this.jitEvents);
        return arrayList;
    }

    public void addNativeBytes(long l) {
        this.stats.addNativeBytes(l);
    }

    public void updateStats(IMetaMember iMetaMember) {
        String string;
        Object object;
        Serializable throwable;
        Object object2;
        String string22;
        String string3 = iMetaMember.toString();
        for (String string22 : IMetaMember.MODIFIERS) {
            if (!string3.contains(string22 + " ")) continue;
            object2 = "incCount" + string22.substring(0, 1).toUpperCase() + string22.substring(1);
            try {
                throwable = MethodType.methodType(Void.TYPE);
                object = MethodHandles.lookup().findVirtual(JITStats.class, (String)object2, (MethodType)throwable);
                object.invokeExact(this.stats);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
        String string4 = iMetaMember.getCompiledAttribute("compiler");
        if (string4 != null) {
            if ("C1".equalsIgnoreCase(string4)) {
                this.stats.incCountC1();
            } else if ("C2".equalsIgnoreCase(string4)) {
                this.stats.incCountC2();
            }
        }
        if ((string = iMetaMember.getCompiledAttribute("compile_kind")) != null) {
            if ("osr".equalsIgnoreCase(string)) {
                this.stats.incCountOSR();
            } else if ("c2n".equalsIgnoreCase(string)) {
                this.stats.incCountC2N();
            }
        }
        String string5 = iMetaMember.getQueuedAttribute("stamp");
        string22 = iMetaMember.getCompiledAttribute("stamp");
        if (string5 != null && string22 != null) {
            object2 = new BigDecimal(string5);
            throwable = new BigDecimal(string22);
            object = throwable.subtract((BigDecimal)object2);
            BigDecimal bigDecimal = ((BigDecimal)object).multiply(new BigDecimal("1000"));
            long l = bigDecimal.longValue();
            iMetaMember.addCompiledAttribute("compileMillis", Long.toString(l));
            this.stats.recordDelay(l);
        }
    }

    public IMetaMember findMetaMember(String string, String string2) {
        MetaClass metaClass = this.pm.getMetaClass(string);
        IMetaMember iMetaMember = null;
        if (metaClass != null) {
            List<IMetaMember> list = metaClass.getMetaMembers();
            for (IMetaMember iMetaMember2 : list) {
                if (!iMetaMember2.matches(string2)) continue;
                iMetaMember = iMetaMember2;
                break;
            }
        }
        return iMetaMember;
    }

    public void buildMetaClass(String string, String string2, Class<?> clazz) {
        MetaPackage metaPackage = this.pm.getMetaPackage(string);
        if (metaPackage == null) {
            metaPackage = this.pm.buildPackage(string);
        }
        MetaClass metaClass = new MetaClass(metaPackage, string2);
        this.pm.addMetaClass(metaClass);
        metaPackage.addClass(metaClass);
        this.stats.incCountClass();
        if (clazz == null) {
            metaClass.setMissingDef(true);
        } else {
            AbstractMetaMember abstractMetaMember;
            if (clazz.isInterface()) {
                metaClass.setInterface(true);
            }
            for (Method executable : clazz.getDeclaredMethods()) {
                abstractMetaMember = new MetaMethod(executable, metaClass);
                metaClass.addMetaMethod((MetaMethod)abstractMetaMember);
                this.stats.incCountMethod();
            }
            for (Executable executable : clazz.getDeclaredConstructors()) {
                abstractMetaMember = new MetaConstructor((Constructor<?>)executable, metaClass);
                metaClass.addMetaConstructor((MetaConstructor)abstractMetaMember);
                this.stats.incCountConstructor();
            }
        }
    }
}

