/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.loader.BytecodeLoader;
import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.MetaConstructor;
import com.chrisnewland.jitwatch.model.MetaMethod;
import com.chrisnewland.jitwatch.model.MetaPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetaClass
implements Comparable<MetaClass> {
    private String className;
    private MetaPackage classPackage;
    private boolean isInterface = false;
    private boolean missingDef = false;
    private List<MetaMethod> classMethods = new CopyOnWriteArrayList<MetaMethod>();
    private List<MetaConstructor> classConstructors = new CopyOnWriteArrayList<MetaConstructor>();
    private int compiledMethodCount = 0;
    private Map<String, String> bytecodeCache = null;

    public MetaClass(MetaPackage metaPackage, String string) {
        this.classPackage = metaPackage;
        this.className = string;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void incCompiledMethodCount() {
        ++this.compiledMethodCount;
    }

    public void setInterface(boolean bl) {
        this.isInterface = bl;
    }

    public boolean isMissingDef() {
        return this.missingDef;
    }

    public void setMissingDef(boolean bl) {
        this.missingDef = bl;
    }

    public Map<String, String> getBytecodeCache(List<String> list) {
        if (this.bytecodeCache == null) {
            this.bytecodeCache = BytecodeLoader.fetchByteCodeForClass(list, this.getFullyQualifiedName());
        }
        return this.bytecodeCache;
    }

    public String toString2() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.classPackage.getName()).append(".").append(this.className).append(" ").append(this.compiledMethodCount).append("/").append(this.classMethods.size());
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.className;
    }

    public String getFullyQualifiedName() {
        return this.classPackage.getName() + '.' + this.className;
    }

    public MetaPackage getPackage() {
        return this.classPackage;
    }

    public void addMetaMethod(MetaMethod metaMethod) {
        this.classMethods.add(metaMethod);
    }

    public void addMetaConstructor(MetaConstructor metaConstructor) {
        this.classConstructors.add(metaConstructor);
    }

    public List<IMetaMember> getMetaMembers() {
        ArrayList<IMetaMember> arrayList = new ArrayList<IMetaMember>();
        Object[] objectArray = this.classConstructors.toArray(new MetaConstructor[this.classConstructors.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = this.classMethods.toArray(new MetaMethod[this.classMethods.size()]);
        Arrays.sort(objectArray2);
        arrayList.addAll(Arrays.asList(objectArray));
        arrayList.addAll(Arrays.asList(objectArray2));
        return arrayList;
    }

    @Override
    public int compareTo(MetaClass metaClass) {
        return this.getName().compareTo(metaClass.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

