/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.model.AbstractMetaMember;
import com.chrisnewland.jitwatch.model.MetaClass;
import java.lang.reflect.Method;

public class MetaMethod
extends AbstractMetaMember
implements Comparable<MetaMethod> {
    private String methodToString;

    public MetaMethod(Method method, MetaClass metaClass) {
        this.methodToString = method.toString();
        this.methodClass = metaClass;
        this.memberName = method.getName();
        this.returnType = method.getReturnType();
        this.paramTypes = method.getParameterTypes();
        this.modifier = method.getModifiers();
    }

    public String toString() {
        String string = this.methodToString;
        int n = string.indexOf(41);
        if (n != string.length() - 1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    @Override
    public String getSignatureForBytecode() {
        String string = this.methodToString;
        int n = string.lastIndexOf(40);
        if (n != -1) {
            int n2 = n;
            int n3 = -1;
            while (n2-- > 0) {
                if (string.charAt(n2) == '.' && n3 == -1) {
                    n3 = n2;
                }
                if (string.charAt(n2) != ' ') continue;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            if (n3 != -1) {
                stringBuilder.delete(n2 + 1, n3 + 1);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public int compareTo(MetaMethod metaMethod) {
        if (metaMethod == null) {
            return -1;
        }
        return this.toString().compareTo(metaMethod.toString());
    }
}

