/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.model.MetaClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetaPackage
implements Comparable<MetaPackage> {
    private String packageName;
    private List<MetaPackage> childPackages = new CopyOnWriteArrayList<MetaPackage>();
    private List<MetaClass> packageClasses = new CopyOnWriteArrayList<MetaClass>();

    public MetaPackage(String string) {
        this.packageName = string;
    }

    public List<MetaPackage> getChildPackages() {
        Object[] objectArray = this.childPackages.toArray(new MetaPackage[this.childPackages.size()]);
        Arrays.sort(objectArray);
        return new ArrayList<Object>(Arrays.asList(objectArray));
    }

    public void addChildPackage(MetaPackage metaPackage) {
        this.childPackages.add(metaPackage);
    }

    public MetaPackage getChildPackage(String string) {
        for (MetaPackage metaPackage : this.childPackages) {
            if (!metaPackage.getName().equals(string)) continue;
            return metaPackage;
        }
        return null;
    }

    public List<MetaClass> getPackageClasses() {
        Object[] objectArray = this.packageClasses.toArray(new MetaClass[this.packageClasses.size()]);
        Arrays.sort(objectArray);
        return new ArrayList<Object>(Arrays.asList(objectArray));
    }

    public List<String> getPackageComponents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.packageName.indexOf(46) == -1) {
            arrayList.add(this.packageName);
        } else {
            arrayList.addAll(Arrays.asList(this.packageName.split("\\.")));
        }
        return arrayList;
    }

    public void addClass(MetaClass metaClass) {
        this.packageClasses.add(metaClass);
    }

    public String getName() {
        return this.packageName;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(MetaPackage metaPackage) {
        return this.getName().compareTo(metaPackage.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

