/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.model;

import com.chrisnewland.jitwatch.model.MetaClass;
import com.chrisnewland.jitwatch.model.MetaPackage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PackageManager {
    private Map<String, MetaClass> metaClasses;
    private Map<String, MetaPackage> metaPackages;
    private List<MetaPackage> roots;

    public PackageManager() {
        this.clear();
    }

    public void clear() {
        this.metaClasses = new ConcurrentHashMap<String, MetaClass>();
        this.metaPackages = new ConcurrentHashMap<String, MetaPackage>();
        this.roots = new CopyOnWriteArrayList<MetaPackage>();
    }

    public void addMetaClass(MetaClass metaClass) {
        this.metaClasses.put(metaClass.getFullyQualifiedName(), metaClass);
    }

    public MetaClass getMetaClass(String string) {
        return this.metaClasses.get(string);
    }

    public MetaPackage getMetaPackage(String string) {
        return this.metaPackages.get(string);
    }

    public MetaPackage buildPackage(String string) {
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        MetaPackage metaPackage = null;
        MetaPackage metaPackage2 = null;
        int n = 0;
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string2);
            String string3 = stringBuilder.toString();
            metaPackage = this.metaPackages.get(string3);
            if (metaPackage == null) {
                metaPackage = new MetaPackage(string3);
                if (n == 0) {
                    this.roots.add(metaPackage);
                } else {
                    metaPackage2.addChildPackage(metaPackage);
                }
                this.metaPackages.put(string3, metaPackage);
            }
            metaPackage2 = metaPackage;
            ++n;
        }
        if (metaPackage == null) {
            metaPackage = new MetaPackage("");
            this.metaPackages.put("", metaPackage);
        }
        return metaPackage;
    }

    public List<MetaPackage> getRootPackages() {
        return this.roots;
    }
}

