/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.toplist;

import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.MetaClass;
import com.chrisnewland.jitwatch.model.MetaPackage;
import com.chrisnewland.jitwatch.model.PackageManager;
import com.chrisnewland.jitwatch.toplist.MemberScore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ToplistTreeWalker {
    public static List<MemberScore> buildTopListForAttribute(PackageManager packageManager, boolean bl, String string) {
        ArrayList<MemberScore> arrayList = new ArrayList<MemberScore>();
        List<MetaPackage> list = packageManager.getRootPackages();
        for (MetaPackage metaPackage : list) {
            ToplistTreeWalker.walkTree(metaPackage, arrayList, bl, string);
        }
        Collections.sort(arrayList, new Comparator<MemberScore>(){

            @Override
            public int compare(MemberScore memberScore, MemberScore memberScore2) {
                return Long.compare(memberScore2.getScore(), memberScore.getScore());
            }
        });
        return arrayList;
    }

    private static void walkTree(MetaPackage metaPackage, List<MemberScore> list, boolean bl, String string) {
        List<MetaPackage> list2 = metaPackage.getChildPackages();
        for (MetaPackage object2 : list2) {
            ToplistTreeWalker.walkTree(object2, list, bl, string);
        }
        List<MetaClass> list3 = metaPackage.getPackageClasses();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            MetaClass metaClass = (MetaClass)iterator.next();
            for (IMetaMember iMetaMember : metaClass.getMetaMembers()) {
                String string2 = null;
                string2 = bl ? iMetaMember.getCompiledAttribute(string) : iMetaMember.getQueuedAttribute(string);
                if (string2 == null) continue;
                long l = Long.valueOf(string2);
                list.add(new MemberScore(iMetaMember, l));
            }
        }
    }
}

