/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.core.JITWatchConfig;
import com.chrisnewland.jitwatch.ui.FileChooserList;
import com.chrisnewland.jitwatch.ui.JITWatchUI;
import com.chrisnewland.jitwatch.util.StringUtil;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class ConfigStage
extends Stage {
    public ConfigStage(final JITWatchUI jITWatchUI, final JITWatchConfig jITWatchConfig) {
        this.initStyle(StageStyle.UTILITY);
        VBox vBox = new VBox();
        Label label = new Label("Package filter (leave empty to show all packages)");
        final TextArea textArea = new TextArea();
        textArea.setText(StringUtil.listToText(jITWatchConfig.getAllowedPackages(), "\n"));
        textArea.setDisable(false);
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        final FileChooserList fileChooserList = new FileChooserList(this, "Source locations", jITWatchConfig.getSourceLocations());
        final FileChooserList fileChooserList2 = new FileChooserList(this, "Class locations", jITWatchConfig.getClassLocations());
        HBox hBox = new HBox();
        hBox.setSpacing(20.0);
        hBox.setPadding(new Insets(10.0));
        hBox.setAlignment(Pos.CENTER);
        Button button = new Button("Save");
        Button button2 = new Button("Cancel");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                jITWatchConfig.setAllowedPackages(StringUtil.textToList(textArea.getText(), "\n"));
                jITWatchConfig.setSourceLocations(fileChooserList.getFiles());
                jITWatchConfig.setClassLocations(fileChooserList2.getFiles());
                jITWatchConfig.saveConfig();
                jITWatchUI.handleStageClosed(ConfigStage.this);
                ConfigStage.this.close();
            }
        });
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                jITWatchUI.handleStageClosed(ConfigStage.this);
                ConfigStage.this.close();
            }
        });
        hBox.getChildren().add((Object)button2);
        hBox.getChildren().add((Object)button);
        vBox.getChildren().add((Object)label);
        vBox.getChildren().add((Object)textArea);
        vBox.getChildren().add((Object)fileChooserList);
        vBox.getChildren().add((Object)fileChooserList2);
        vBox.getChildren().add((Object)hBox);
        textArea.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.33));
        fileChooserList.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.33));
        fileChooserList2.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(0.33));
        hBox.setPrefHeight(30.0);
        this.setTitle("JITWatch Configuration");
        Scene scene = new Scene((Parent)vBox, 640.0, 480.0);
        this.setScene(scene);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                jITWatchUI.handleStageClosed(ConfigStage.this);
            }
        });
    }
}

