/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.histo.Histo;
import com.chrisnewland.jitwatch.histo.HistoTreeWalker;
import com.chrisnewland.jitwatch.ui.JITWatchUI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class HistoStage
extends Stage {
    private Canvas canvas;
    private GraphicsContext gc;
    private Histo histo;
    private String selectedAttribute;
    private static final int GRAPH_GAP_LEFT = 60;
    private static final int GRAPH_GAP_RIGHT = 20;
    private static final int GRAPH_GAP_Y = 20;
    private static final long[] Y_SCALE = new long[21];

    public HistoStage(final JITWatchUI jITWatchUI) {
        this.initStyle(StageStyle.DECORATED);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                jITWatchUI.handleStageClosed(HistoStage.this);
            }
        });
        int n = 640;
        int n2 = 480;
        this.canvas = new Canvas((double)n, (double)n2);
        this.gc = this.canvas.getGraphicsContext2D();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Method JIT-Compilation Times", "compileMillis");
        hashMap.put("Bytecodes per Compiled Method", "bytes");
        hashMap.put("Native Bytes per Compiled Method", "nmsize");
        VBox vBox = new VBox();
        ObservableList observableList = FXCollections.observableArrayList(hashMap.keySet());
        this.selectedAttribute = (String)hashMap.get(observableList.get(0));
        ComboBox comboBox = new ComboBox(observableList);
        comboBox.setValue(observableList.get(0));
        comboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                HistoStage.this.selectedAttribute = (String)hashMap.get(string2);
                HistoStage.this.histo = HistoTreeWalker.buildHistoForAttribute(jITWatchUI.getPackageManager(), true, HistoStage.this.selectedAttribute, 10L);
                HistoStage.this.redraw();
            }
        });
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(4.0, 0.0, 0.0, 60.0));
        hBox.getChildren().add((Object)comboBox);
        vBox.getChildren().add((Object)hBox);
        vBox.getChildren().add((Object)this.canvas);
        Scene scene = new Scene((Parent)vBox, (double)n, (double)n2);
        this.canvas.widthProperty().bind((ObservableValue)scene.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)scene.heightProperty().subtract(30));
        class SceneResizeListener
        implements ChangeListener<Number> {
            SceneResizeListener() {
            }

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                HistoStage.this.redraw();
            }
        }
        SceneResizeListener sceneResizeListener = new SceneResizeListener();
        this.canvas.widthProperty().addListener((ChangeListener)sceneResizeListener);
        this.canvas.heightProperty().addListener((ChangeListener)sceneResizeListener);
        this.setTitle("JITWatch Histogram");
        this.histo = HistoTreeWalker.buildHistoForAttribute(jITWatchUI.getPackageManager(), true, this.selectedAttribute, 10L);
        this.setScene(scene);
        this.show();
        this.redraw();
    }

    public void redraw() {
        List<Map.Entry<Long, Integer>> list = this.histo.getSortedData();
        double d = this.canvas.getWidth();
        double d2 = this.canvas.getHeight();
        double d3 = d - 60.0 - 20.0;
        double d4 = d2 - 40.0;
        this.gc.setFill((Paint)Color.WHITE);
        this.gc.fillRect(0.0, 0.0, d, d2);
        this.gc.setFill((Paint)Color.BEIGE);
        this.gc.fillRect(60.0, 20.0, d3, d4);
        this.gc.setStroke((Paint)Color.BLACK);
        this.gc.strokeRect(60.0, 20.0, d3, d4);
        if (list.size() > 0) {
            double d5 = 0.0;
            double d6 = this.histo.getLastTime();
            int n = this.histo.getMaxCount();
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.setFont(new Font("monospace", 10.0));
            double d7 = this.findScale((long)d6);
            int n2 = 0;
            while ((double)n2 < d6) {
                double d8 = 60.0 + this.normalise(n2, 0.0, d6, d3, false);
                this.gc.strokeLine(d8, 20.0, d8, 20.0 + d4);
                this.gc.strokeText(Integer.toString(n2), d8, 20.0 + d4 + 12.0);
                n2 = (int)((double)n2 + d7);
            }
            long l = this.findScale(n);
            int n3 = 0;
            while (n3 < n) {
                double d9 = 20.0 + this.normalise(n3, 0.0, n, d4, true);
                this.gc.strokeLine(60.0, d9, 60.0 + d3, d9);
                this.gc.strokeText(Integer.toString(n3), 2.0, d9 + 2.0);
                n3 = (int)((long)n3 + l);
            }
            Color color = Color.RED;
            for (Map.Entry<Long, Integer> entry : list) {
                long l2 = entry.getKey();
                int n4 = entry.getValue();
                double d10 = 60.0 + this.normalise(l2, d5, d6, d3, false);
                this.gc.setStroke((Paint)color);
                double d11 = 20.0 + this.normalise(n4, 0.0, n, d4, true);
                this.gc.strokeLine(d10, 20.0 + d4, d10, d11);
            }
            double d12 = 100.0;
            double d13 = 185.0;
            double d14 = this.canvas.getWidth() - 20.0 - d12 - 5.0;
            double d15 = 25.0;
            this.gc.setFill((Paint)Color.WHITE);
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.fillRect(d14, d15, d12, d13);
            this.gc.strokeRect(d14, d15, d12, d13);
            d14 += 5.0;
            d15 += 15.0;
            for (int n5 : new int[]{50, 75, 80, 85, 90, 95, 98, 99, 100}) {
                this.gc.strokeText(n5 + "% : " + this.histo.getPercentile(n5), d14, d15);
                d15 += 20.0;
            }
        }
    }

    private long findScale(long l) {
        long l2 = 10L;
        for (int i = 0; i < Y_SCALE.length; ++i) {
            if (l / Y_SCALE[i] >= l2) continue;
            return Y_SCALE[i];
        }
        return l / l2;
    }

    private double normalise(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = d3 - d2;
        double d6 = 0.0;
        d6 = d5 == 0.0 ? 0.0 : (d - d2) / d5;
        d6 *= d4;
        if (bl) {
            d6 = d4 - d6;
        }
        return d6;
    }

    static {
        int n = 1;
        for (int i = 0; i < Y_SCALE.length; i += 3) {
            HistoStage.Y_SCALE[i + 0] = 1 * n;
            HistoStage.Y_SCALE[i + 1] = 2 * n;
            HistoStage.Y_SCALE[i + 2] = 5 * n;
            n *= 10;
        }
    }
}

