/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.core.HotSpotLogParser;
import com.chrisnewland.jitwatch.core.IJITListener;
import com.chrisnewland.jitwatch.core.JITEvent;
import com.chrisnewland.jitwatch.core.JITStats;
import com.chrisnewland.jitwatch.core.JITWatchConfig;
import com.chrisnewland.jitwatch.loader.ResourceLoader;
import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.model.JITDataModel;
import com.chrisnewland.jitwatch.model.MetaClass;
import com.chrisnewland.jitwatch.model.MetaPackage;
import com.chrisnewland.jitwatch.model.PackageManager;
import com.chrisnewland.jitwatch.ui.AttributeTableRow3Col;
import com.chrisnewland.jitwatch.ui.ConfigStage;
import com.chrisnewland.jitwatch.ui.HistoStage;
import com.chrisnewland.jitwatch.ui.StatsStage;
import com.chrisnewland.jitwatch.ui.TableUtil;
import com.chrisnewland.jitwatch.ui.TextViewerStage;
import com.chrisnewland.jitwatch.ui.TimeLineStage;
import com.chrisnewland.jitwatch.ui.TopListStage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.TimelineBuilder;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;

public class JITWatchUI
extends Application
implements IJITListener {
    private Stage stage;
    private JITDataModel model;
    private HotSpotLogParser logParser;
    private TreeView<Object> treeView;
    private TreeItem<Object> rootItem;
    private ListView<IMetaMember> memberList;
    private TableView<AttributeTableRow3Col> attributeTableView;
    private ObservableList<AttributeTableRow3Col> memberAttrList;
    private boolean showOnlyCompiled = true;
    private boolean hideInterfaces = true;
    private TreeItem<Object> selectedNode;
    private List<Stage> openPopupStages = new ArrayList<Stage>();
    private TextArea textArea;
    private File watchFile = null;
    private boolean isWatching = false;
    private Button btnStartWatching;
    private Button btnStopWatching;
    private Button btnConfigure;
    private Button btnTimeLine;
    private Button btnStats;
    private Button btnHisto;
    private Button btnTopList;
    private Button btnErrorLog;
    private Label lblHeap;
    private ConfigStage configStage;
    private TimeLineStage timeLineStage;
    private StatsStage statsStage;
    private HistoStage histoStage;
    private TopListStage topListStage;
    private IMetaMember selectedMember;
    private Runtime runtime = Runtime.getRuntime();
    private StringBuffer logBuffer = new StringBuffer();
    private StringBuilder errorLog = new StringBuilder();
    private int errorCount = 0;
    private boolean repaintTree = false;
    private JITWatchConfig config;

    public JITWatchUI() {
        this.model = new JITDataModel();
        this.config = new JITWatchConfig(this);
        this.logParser = new HotSpotLogParser(this.model, this.config, this);
    }

    public JITWatchUI(String[] stringArray) {
        JITWatchUI.launch((String[])stringArray);
    }

    public void setHotSpotLogFile(File file) {
        this.watchFile = file;
        this.updateButtons();
    }

    private void startWatching() {
        this.model.reset();
        this.textArea.clear();
        this.selectedMember = null;
        this.errorCount = 0;
        this.errorLog.delete(0, this.errorLog.length());
        this.refreshSelectedTreeNode();
        this.rootItem.getChildren().clear();
        this.isWatching = true;
        this.updateButtons();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JITWatchUI.this.logParser.watch(JITWatchUI.this.watchFile);
                }
                catch (IOException iOException) {
                    JITWatchUI.this.log("Exception during log processing: " + iOException.toString());
                }
            }
        });
        thread.start();
    }

    private void stopWatching() {
        if (this.isWatching) {
            this.logParser.stop();
            this.isWatching = false;
            this.updateButtons();
            this.log("Stopped watching " + this.watchFile.getAbsolutePath());
        }
    }

    public void start(Stage stage) {
        this.stage = stage;
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                for (Stage stage : JITWatchUI.this.openPopupStages) {
                    if (stage == null) continue;
                    stage.close();
                }
                JITWatchUI.this.stopWatching();
            }
        });
        this.rootItem = new TreeItem((Object)"Packages");
        this.rootItem.setExpanded(true);
        this.treeView = new TreeView(this.rootItem);
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Object>>(){

            public void changed(ObservableValue<? extends TreeItem<Object>> observableValue, TreeItem<Object> treeItem, TreeItem<Object> treeItem2) {
                JITWatchUI.this.selectedNode = treeItem2;
                JITWatchUI.this.refreshSelectedTreeNode();
            }
        });
        int n = 1024;
        int n2 = 592;
        BorderPane borderPane = new BorderPane();
        Scene scene = new Scene((Parent)borderPane, (double)n, (double)n2);
        CheckBox checkBox = new CheckBox("JIT Only");
        checkBox.setTooltip(new Tooltip("Show only compiled methods in the class methods list"));
        checkBox.setSelected(this.showOnlyCompiled);
        checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                JITWatchUI.this.showOnlyCompiled = bl2;
                JITWatchUI.this.refreshSelectedTreeNode();
            }
        });
        CheckBox checkBox2 = new CheckBox("Hide Interfaces");
        checkBox2.setTooltip(new Tooltip("Hide Interfaces from the Class Tree"));
        checkBox2.setSelected(this.hideInterfaces);
        checkBox2.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                JITWatchUI.this.hideInterfaces = bl2;
                JITWatchUI.this.clearAndRefresh();
            }
        });
        Button button = new Button("Open Log");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.chooseHotSpotFile();
            }
        });
        this.btnStartWatching = new Button("Start");
        this.btnStartWatching.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.startWatching();
            }
        });
        this.btnStopWatching = new Button("Stop");
        this.btnStopWatching.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.stopWatching();
            }
        });
        this.btnConfigure = new Button("Config");
        this.btnConfigure.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.configStage = new ConfigStage(JITWatchUI.this, JITWatchUI.this.config);
                JITWatchUI.this.configStage.show();
                JITWatchUI.this.openPopupStages.add(JITWatchUI.this.configStage);
                JITWatchUI.this.btnConfigure.setDisable(true);
            }
        });
        this.btnTimeLine = new Button("Chart");
        this.btnTimeLine.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.timeLineStage = new TimeLineStage(JITWatchUI.this);
                JITWatchUI.this.timeLineStage.show();
                JITWatchUI.this.openPopupStages.add(JITWatchUI.this.timeLineStage);
                JITWatchUI.this.btnTimeLine.setDisable(true);
            }
        });
        this.btnStats = new Button("Stats");
        this.btnStats.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.statsStage = new StatsStage(JITWatchUI.this);
                JITWatchUI.this.statsStage.show();
                JITWatchUI.this.openPopupStages.add(JITWatchUI.this.statsStage);
                JITWatchUI.this.btnStats.setDisable(true);
            }
        });
        this.btnHisto = new Button("Histo");
        this.btnHisto.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.histoStage = new HistoStage(JITWatchUI.this);
                JITWatchUI.this.histoStage.show();
                JITWatchUI.this.openPopupStages.add(JITWatchUI.this.histoStage);
                JITWatchUI.this.btnHisto.setDisable(true);
            }
        });
        this.btnTopList = new Button("TopList");
        this.btnTopList.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.topListStage = new TopListStage(JITWatchUI.this);
                JITWatchUI.this.topListStage.show();
                JITWatchUI.this.openPopupStages.add(JITWatchUI.this.topListStage);
                JITWatchUI.this.btnTopList.setDisable(true);
            }
        });
        this.btnErrorLog = new Button("Errors (0)");
        this.btnErrorLog.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TextViewerStage textViewerStage = new TextViewerStage(JITWatchUI.this, "Error Log", JITWatchUI.this.errorLog.toString(), false);
                textViewerStage.show();
                JITWatchUI.this.openPopupStages.add(textViewerStage);
            }
        });
        this.lblHeap = new Label();
        int n3 = 50;
        int n4 = 100;
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(10.0));
        hBox.getChildren().add((Object)button);
        hBox.getChildren().add((Object)this.btnStartWatching);
        hBox.getChildren().add((Object)this.btnStopWatching);
        hBox.getChildren().add((Object)this.btnConfigure);
        hBox.getChildren().add((Object)this.btnTimeLine);
        hBox.getChildren().add((Object)this.btnStats);
        hBox.getChildren().add((Object)this.btnHisto);
        hBox.getChildren().add((Object)this.btnTopList);
        hBox.getChildren().add((Object)this.btnErrorLog);
        hBox.getChildren().add((Object)checkBox);
        hBox.getChildren().add((Object)checkBox2);
        hBox.getChildren().add((Object)this.lblHeap);
        hBox.setPrefHeight((double)n3);
        hBox.setSpacing(10.0);
        this.memberList = new ListView();
        this.memberList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<IMetaMember>(){

            public void changed(ObservableValue<? extends IMetaMember> observableValue, IMetaMember iMetaMember, IMetaMember iMetaMember2) {
                JITWatchUI.this.showMemberInfo(iMetaMember2);
            }
        });
        final ContextMenu contextMenu = new ContextMenu();
        final ContextMenu contextMenu2 = new ContextMenu();
        MenuItem menuItem = new MenuItem("Show Source");
        MenuItem menuItem2 = new MenuItem("Show Bytecode");
        MenuItem menuItem3 = new MenuItem("Show Native Code");
        contextMenu.getItems().add((Object)menuItem);
        contextMenu.getItems().add((Object)menuItem2);
        contextMenu.getItems().add((Object)menuItem3);
        contextMenu2.getItems().add((Object)menuItem);
        contextMenu2.getItems().add((Object)menuItem2);
        this.memberList.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    if (JITWatchUI.this.selectedMember.isCompiled()) {
                        contextMenu.show((Node)JITWatchUI.this.memberList, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                    } else {
                        contextMenu2.show((Node)JITWatchUI.this.memberList, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                    }
                }
            }
        });
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.openSource((IMetaMember)JITWatchUI.this.memberList.getSelectionModel().getSelectedItem());
            }
        });
        menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.openBytecode((IMetaMember)JITWatchUI.this.memberList.getSelectionModel().getSelectedItem());
            }
        });
        menuItem3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.openNativeCode((IMetaMember)JITWatchUI.this.memberList.getSelectionModel().getSelectedItem());
            }
        });
        this.memberAttrList = FXCollections.observableArrayList();
        this.attributeTableView = TableUtil.buildTableMemberAttributes(this.memberAttrList);
        this.attributeTableView.setPlaceholder((Node)new Text("Select a method to view HotSpot attributes."));
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.VERTICAL);
        splitPane.getItems().add(this.memberList);
        splitPane.getItems().add(this.attributeTableView);
        this.memberList.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        this.attributeTableView.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        this.treeView.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        SplitPane splitPane2 = new SplitPane();
        splitPane2.setOrientation(Orientation.VERTICAL);
        SplitPane splitPane3 = new SplitPane();
        splitPane3.getItems().add(this.treeView);
        splitPane3.getItems().add((Object)splitPane);
        splitPane3.setDividerPositions(new double[]{0.3, 0.7});
        this.textArea = new TextArea();
        this.textArea.setStyle("-fx-font-family:monospace;");
        this.textArea.setPrefHeight((double)n4);
        this.textArea.setText("Welcome to JITWatch\n");
        if (this.watchFile == null) {
            this.log("Please choose a HotSpot log file");
        } else {
            this.log("Using HotSpot log file: " + this.watchFile.getAbsolutePath());
        }
        splitPane2.getItems().add((Object)splitPane3);
        splitPane2.getItems().add((Object)this.textArea);
        splitPane2.setDividerPositions(new double[]{0.7, 0.3});
        borderPane.setTop((Node)hBox);
        borderPane.setCenter((Node)splitPane2);
        stage.setTitle("JITWatch - HotSpot Compilation Inspector");
        stage.setScene(scene);
        stage.show();
        int n5 = 1000;
        Duration duration = Duration.millis((double)n5);
        KeyFrame keyFrame = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JITWatchUI.this.refresh();
            }
        }, new KeyValue[0]);
        ((TimelineBuilder)TimelineBuilder.create().cycleCount(-1)).keyFrames(new KeyFrame[]{keyFrame}).build().play();
        this.updateButtons();
    }

    public JITStats getJITStats() {
        return this.model.getJITStats();
    }

    private void updateButtons() {
        this.btnStartWatching.setDisable(this.watchFile == null || this.isWatching);
        this.btnStopWatching.setDisable(!this.isWatching);
    }

    public List<JITEvent> getJITEvents() {
        return this.model.getEventListCopy();
    }

    public void openTreeAtMember(IMetaMember iMetaMember) {
        List<String> list = iMetaMember.getTreePath();
        this.clearAndRefresh();
        TreeItem treeItem = this.rootItem;
        StringBuilder stringBuilder = new StringBuilder();
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        block0: for (String string : list) {
            stringBuilder.append(string);
            bl = false;
            String string2 = n2++ == n - 1 ? string : stringBuilder.toString();
            for (TreeItem treeItem2 : treeItem.getChildren()) {
                ++n3;
                String string3 = treeItem2.getValue().toString();
                if (!string2.equals(string3)) continue;
                stringBuilder.append('.');
                treeItem = treeItem2;
                treeItem.setExpanded(true);
                this.treeView.getSelectionModel().select((Object)treeItem);
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            this.treeView.scrollTo(n3);
            this.memberList.getSelectionModel().select((Object)iMetaMember);
            this.memberList.scrollTo(this.memberList.getSelectionModel().getSelectedIndex());
        }
    }

    private void openSource(IMetaMember iMetaMember) {
        MetaClass metaClass = iMetaMember.getMetaClass();
        String string = metaClass.getFullyQualifiedName();
        string = string.replace(".", "/") + ".java";
        String string2 = ResourceLoader.getSource(this.config.getSourceLocations(), string);
        TextViewerStage textViewerStage = null;
        String string3 = "Source code for " + string;
        for (Stage stage : this.openPopupStages) {
            if (!(stage instanceof TextViewerStage) || !string3.equals(stage.getTitle())) continue;
            textViewerStage = (TextViewerStage)stage;
            break;
        }
        if (textViewerStage == null) {
            textViewerStage = new TextViewerStage(this, string3, string2, true);
            textViewerStage.show();
            this.openPopupStages.add(textViewerStage);
        }
        textViewerStage.requestFocus();
        textViewerStage.jumpTo(iMetaMember.getSignatureRegEx());
    }

    private void openBytecode(IMetaMember iMetaMember) {
        String string = iMetaMember.getSignatureForBytecode();
        MetaClass metaClass = iMetaMember.getMetaClass();
        Map<String, String> map = metaClass.getBytecodeCache(this.config.getClassLocations());
        String string2 = map.get(string);
        TextViewerStage textViewerStage = new TextViewerStage(this, "Bytecode for " + iMetaMember.toString(), string2, false);
        textViewerStage.show();
        this.openPopupStages.add(textViewerStage);
    }

    private void openNativeCode(IMetaMember iMetaMember) {
        String string = iMetaMember.getNativeCode();
        TextViewerStage textViewerStage = new TextViewerStage(this, "Native code for " + iMetaMember.toString(), string, false);
        textViewerStage.show();
        this.openPopupStages.add(textViewerStage);
    }

    private void chooseHotSpotFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choose HotSpot log file");
        String string = System.getProperty("user.dir");
        File file = new File(string);
        fileChooser.setInitialDirectory(file);
        File file2 = fileChooser.showOpenDialog((Window)this.stage);
        if (file2 != null) {
            this.watchFile = file2;
            this.log("Selected file: " + this.watchFile.getAbsolutePath());
            this.log("Click Start button to process or tail the file");
            this.updateButtons();
            this.refreshLog();
        }
    }

    private void showMemberInfo(IMetaMember iMetaMember) {
        this.memberAttrList.clear();
        if (iMetaMember == null) {
            return;
        }
        this.selectedMember = iMetaMember;
        List<String> list = iMetaMember.getQueuedAttributes();
        for (String object2 : list) {
            this.memberAttrList.add((Object)new AttributeTableRow3Col("Queued", object2, iMetaMember.getQueuedAttribute(object2)));
        }
        List<String> list2 = iMetaMember.getCompiledAttributes();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.memberAttrList.add((Object)new AttributeTableRow3Col("Compiled", string, iMetaMember.getCompiledAttribute(string)));
        }
    }

    private void refresh() {
        if (this.repaintTree) {
            this.repaintTree = false;
            this.showTree();
        }
        if (this.timeLineStage != null) {
            this.timeLineStage.redraw();
        }
        if (this.statsStage != null) {
            this.statsStage.redraw();
        }
        if (this.histoStage != null) {
            this.histoStage.redraw();
        }
        if (this.topListStage != null) {
            this.topListStage.redraw();
        }
        if (this.logBuffer.length() > 0) {
            this.refreshLog();
        }
        long l = this.runtime.totalMemory();
        long l2 = this.runtime.freeMemory();
        long l3 = l - l2;
        long l4 = 0x100000L;
        String string = "Heap: " + l3 / l4 + "/" + l / l4 + "M";
        this.lblHeap.setText(string);
        this.btnErrorLog.setText("Errors (" + this.errorCount + ")");
    }

    private void refreshLog() {
        this.textArea.appendText(this.logBuffer.toString());
        this.logBuffer.delete(0, this.logBuffer.length());
    }

    public IMetaMember getSelectedMember() {
        return this.selectedMember;
    }

    private void clearAndRefresh() {
        this.selectedMember = null;
        this.rootItem.getChildren().clear();
        this.showTree();
    }

    public void handleStageClosed(Stage stage) {
        this.openPopupStages.remove(stage);
        if (stage instanceof TimeLineStage) {
            this.btnTimeLine.setDisable(false);
            this.timeLineStage = null;
        } else if (stage instanceof StatsStage) {
            this.btnStats.setDisable(false);
            this.statsStage = null;
        } else if (stage instanceof HistoStage) {
            this.btnHisto.setDisable(false);
            this.histoStage = null;
        } else if (stage instanceof ConfigStage) {
            this.btnConfigure.setDisable(false);
            this.configStage = null;
        } else if (stage instanceof TopListStage) {
            this.btnTopList.setDisable(false);
            this.topListStage = null;
        }
    }

    @Override
    public void handleJITEvent(JITEvent jITEvent) {
        this.log(jITEvent.toString());
        this.repaintTree = true;
    }

    @Override
    public void handleLogEntry(String string) {
        this.log(string);
    }

    @Override
    public void handleErrorEntry(String string) {
        this.errorLog.append(string).append("\n");
        ++this.errorCount;
    }

    private void log(String string) {
        this.logBuffer.append(string + "\n");
    }

    private TreeItem<Object> findOrCreateTreeItem(TreeItem<Object> treeItem, Object object) {
        ObservableList observableList = treeItem.getChildren();
        TreeItem treeItem2 = null;
        int n = 0;
        boolean bl = false;
        for (TreeItem treeItem3 : observableList) {
            int n2 = treeItem3.getValue().toString().compareTo(object.toString());
            if (n2 == 0) {
                treeItem2 = treeItem3;
                break;
            }
            if (!bl && n2 < 0) {
                if (treeItem3.getValue() instanceof MetaPackage && object instanceof MetaClass) continue;
                ++n;
                continue;
            }
            if (treeItem3.getValue() instanceof MetaPackage && object instanceof MetaClass) {
                ++n;
                continue;
            }
            bl = true;
        }
        if (treeItem2 == null) {
            treeItem2 = new TreeItem(object);
            observableList.add(n, (Object)treeItem2);
            if (!(object instanceof MetaClass) || ((MetaClass)object).isMissingDef()) {
                // empty if block
            }
        }
        return treeItem2;
    }

    private void refreshSelectedTreeNode() {
        this.memberList.getItems().clear();
        this.showMemberInfo(null);
        if (this.selectedNode == null) {
            return;
        }
        Object object = this.selectedNode.getValue();
        if (object instanceof MetaClass) {
            MetaClass metaClass = (MetaClass)object;
            List<IMetaMember> list = metaClass.getMetaMembers();
            for (IMetaMember iMetaMember : list) {
                if (iMetaMember.isCompiled()) {
                    this.memberList.getItems().add((Object)iMetaMember);
                    continue;
                }
                if (this.showOnlyCompiled) continue;
                this.memberList.getItems().add((Object)iMetaMember);
            }
            this.memberList.setCellFactory((Callback)new Callback<ListView<IMetaMember>, ListCell<IMetaMember>>(){

                public ListCell<IMetaMember> call(ListView<IMetaMember> listView) {
                    return new MetaMethodCell();
                }
            });
        }
    }

    public PackageManager getPackageManager() {
        return this.model.getPackageManager();
    }

    private void showTree() {
        List<MetaPackage> list = this.model.getPackageManager().getRootPackages();
        for (MetaPackage metaPackage : list) {
            this.showTree(this.rootItem, metaPackage);
        }
    }

    private void showTree(TreeItem<Object> treeItem, MetaPackage metaPackage) {
        TreeItem<Object> treeItem2 = this.findOrCreateTreeItem(treeItem, metaPackage);
        List<MetaPackage> list = metaPackage.getChildPackages();
        for (MetaPackage object2 : list) {
            this.showTree(treeItem2, object2);
        }
        List<MetaClass> list2 = metaPackage.getPackageClasses();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            MetaClass metaClass = (MetaClass)iterator.next();
            if (this.hideInterfaces && metaClass.isInterface()) continue;
            this.findOrCreateTreeItem(treeItem2, metaClass);
        }
    }

    static class MetaMethodCell
    extends ListCell<IMetaMember> {
        MetaMethodCell() {
        }

        public void updateItem(IMetaMember iMetaMember, boolean bl) {
            super.updateItem((Object)iMetaMember, bl);
            if (iMetaMember != null) {
                this.setText(iMetaMember.toStringUnqualifiedMethodName());
                if (this.isSelected()) {
                    this.setTextFill((Paint)Color.WHITE);
                } else if (iMetaMember.isCompiled()) {
                    this.setTextFill((Paint)Color.RED);
                } else {
                    this.setTextFill((Paint)Color.BLACK);
                }
            }
        }
    }
}

