/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.core.JITStats;
import com.chrisnewland.jitwatch.ui.AttributeTableRow2Col;
import com.chrisnewland.jitwatch.ui.JITWatchUI;
import com.chrisnewland.jitwatch.ui.TableUtil;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class StatsStage
extends Stage {
    private TableView<AttributeTableRow2Col> tableView;
    private ObservableList<AttributeTableRow2Col> obList = FXCollections.observableArrayList();
    private JITWatchUI parent;

    public StatsStage(final JITWatchUI jITWatchUI) {
        this.initStyle(StageStyle.DECORATED);
        this.parent = jITWatchUI;
        VBox vBox = new VBox();
        Scene scene = new Scene((Parent)vBox, 360.0, 450.0);
        this.tableView = TableUtil.buildTableStats(this.obList);
        vBox.getChildren().add(this.tableView);
        this.tableView.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        this.setTitle("JITWatch Method Statistics");
        this.setScene(scene);
        this.redraw();
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                jITWatchUI.handleStageClosed(StatsStage.this);
            }
        });
    }

    public void redraw() {
        this.obList.clear();
        JITStats jITStats = this.parent.getJITStats();
        this.obList.add((Object)this.makeRow("Public", jITStats.getCountPublic()));
        this.obList.add((Object)this.makeRow("Private", jITStats.getCountPrivate()));
        this.obList.add((Object)this.makeRow("Protected", jITStats.getCountProtected()));
        this.obList.add((Object)this.makeRow("Static", jITStats.getCountStatic()));
        this.obList.add((Object)this.makeRow("Final", jITStats.getCountFinal()));
        this.obList.add((Object)this.makeRow("Synchronized", jITStats.getCountSynchronized()));
        this.obList.add((Object)this.makeRow("Strictfp", jITStats.getCountStrictfp()));
        this.obList.add((Object)this.makeRow("Native", jITStats.getCountNative()));
        this.obList.add((Object)this.makeRow("C1 Compiled", jITStats.getCountC1()));
        this.obList.add((Object)this.makeRow("C2 Compiled", jITStats.getCountC2()));
        this.obList.add((Object)this.makeRow("OSR", jITStats.getCountOSR()));
        this.obList.add((Object)this.makeRow("C2N Compiled", jITStats.getCountC2N()));
        this.obList.add((Object)this.makeRow("Total JIT Time", jITStats.getTotalCompileTime()));
        this.obList.add((Object)this.makeRow("Native bytes", jITStats.getNativeBytes()));
        this.obList.add((Object)this.makeRow("Loaded Classes", jITStats.getCountClass()));
        this.obList.add((Object)this.makeRow("Total Methods", jITStats.getCountMethod()));
        this.obList.add((Object)this.makeRow("Total Constructors", jITStats.getCountConstructor()));
    }

    private AttributeTableRow2Col makeRow(String string, long l) {
        return new AttributeTableRow2Col(string, l);
    }
}

