/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.core.JITEvent;
import com.chrisnewland.jitwatch.core.JITStats;
import com.chrisnewland.jitwatch.model.IMetaMember;
import com.chrisnewland.jitwatch.ui.JITWatchUI;
import com.chrisnewland.jitwatch.util.StringUtil;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class TimeLineStage
extends Stage {
    private Canvas canvas;
    private GraphicsContext gc;
    private JITWatchUI parent;
    private static final int GRAPH_GAP_LEFT = 60;
    private static final int GRAPH_GAP_RIGHT = 20;
    private static final int GRAPH_GAP_Y = 20;
    private static final int[] Y_SCALE = new int[21];

    public TimeLineStage(final JITWatchUI jITWatchUI) {
        this.parent = jITWatchUI;
        this.initStyle(StageStyle.DECORATED);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                jITWatchUI.handleStageClosed(TimeLineStage.this);
            }
        });
        int n = 640;
        int n2 = 480;
        this.canvas = new Canvas((double)n, (double)n2);
        this.gc = this.canvas.getGraphicsContext2D();
        StackPane stackPane = new StackPane();
        Scene scene = new Scene((Parent)stackPane, (double)n, (double)n2);
        this.canvas.widthProperty().bind((ObservableValue)stackPane.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)stackPane.heightProperty());
        class SceneResizeListener
        implements ChangeListener<Number> {
            SceneResizeListener() {
            }

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                TimeLineStage.this.redraw();
            }
        }
        SceneResizeListener sceneResizeListener = new SceneResizeListener();
        this.canvas.widthProperty().addListener((ChangeListener)sceneResizeListener);
        this.canvas.heightProperty().addListener((ChangeListener)sceneResizeListener);
        stackPane.getChildren().add((Object)this.canvas);
        this.setTitle("JITWatch Compilations Timeline");
        this.setScene(scene);
        this.show();
        this.redraw();
    }

    public void redraw() {
        List<JITEvent> list = this.parent.getJITEvents();
        if (list.size() > 0) {
            Object object;
            double d = this.canvas.getWidth();
            double d2 = this.canvas.getHeight();
            double d3 = d - 60.0 - 20.0;
            double d4 = d2 - 40.0;
            this.gc.setFill((Paint)Color.WHITE);
            this.gc.fillRect(0.0, 0.0, d, d2);
            this.gc.setFill((Paint)Color.BEIGE);
            this.gc.fillRect(60.0, 20.0, d3, d4);
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.strokeRect(60.0, 20.0, d3, d4);
            long l = 0L;
            long l2 = list.get(list.size() - 1).getStamp();
            int n = (int)((double)list.size() / 2.0 * 1.2);
            double d5 = 60.0 + this.normalise(0.0, l, l2, d3, false);
            double d6 = 20.0 + this.normalise(0.0, 0.0, n, d4, true);
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.setFont(new Font("monospace", 10.0));
            this.drawXAxis(this.gc, l, l2, d3, d4);
            this.drawYAxis(this.gc, n, d3, d4);
            IMetaMember iMetaMember = this.parent.getSelectedMember();
            double d7 = -1.0;
            if (iMetaMember != null && (object = iMetaMember.getCompiledAttribute("stamp")) != null) {
                d7 = 1000.0 * Double.parseDouble((String)object);
            }
            object = Color.RED;
            Color color = Color.BLUE;
            int n2 = 0;
            int n3 = 8;
            for (JITEvent jITEvent : list) {
                double d8;
                long l3 = jITEvent.getStamp();
                double d9 = 60.0 + this.normalise(l3, l, l2, d3, false);
                if (!jITEvent.isCompile()) continue;
                this.gc.setFill((Paint)object);
                this.gc.setStroke((Paint)object);
                double d10 = 20.0 + this.normalise(++n2, 0.0, n, d4, true);
                this.gc.strokeLine(d5, d6, d9, d10);
                d5 = d9;
                d6 = d10;
                if (d7 == -1.0 || !((double)l3 > d7)) continue;
                double d11 = 60.0 + this.normalise(d7, l, l2, d3, false);
                this.gc.setFill((Paint)color);
                this.gc.setStroke((Paint)color);
                this.gc.fillOval(d11 - (double)(n3 / 2), d10 - (double)(n3 / 2), (double)n3, (double)n3);
                String string = iMetaMember.toStringUnqualifiedMethodName();
                String string2 = iMetaMember.getCompiledAttribute("compiler");
                if (string2 == null && (string2 = iMetaMember.getCompiledAttribute("compile_kind")) == null) {
                    string2 = "unknown!";
                }
                String string3 = "Compiled at " + StringUtil.formatTimestamp((long)d7, true) + " using " + string2;
                String string4 = iMetaMember.getCompiledAttribute("compileMillis");
                if (string4 != null) {
                    string3 = string3 + " took " + string4 + "ms";
                }
                if ((d8 = d10) > 20.0 + d4 - 32.0) {
                    d8 = 20.0 + d4 - 32.0;
                }
                this.gc.strokeText(string, d11 + 10.0, d8);
                this.gc.strokeText(string3, d11 + 10.0, d8 + 16.0);
                d7 = -1.0;
            }
            this.showStatsLegend(this.gc);
        }
    }

    private void showStatsLegend(GraphicsContext graphicsContext) {
        JITStats jITStats = this.parent.getJITStats();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Compiled: ").append(jITStats.getTotalCompiledMethods());
        stringBuilder.append(" (C1: ").append(jITStats.getCountC1()).append(")");
        stringBuilder.append(" (C2: ").append(jITStats.getCountC2()).append(")");
        stringBuilder.append(" (C2N: ").append(jITStats.getCountC2N()).append(")");
        stringBuilder.append(" (OSR: ").append(jITStats.getCountOSR()).append(")");
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.strokeText(stringBuilder.toString(), 60.0, 12.0);
    }

    private void drawXAxis(GraphicsContext graphicsContext, long l, long l2, double d, double d2) {
        long l3 = this.getXStep(l, l2);
        int n = 0;
        while ((long)n < l2) {
            double d3 = 60.0 + this.normalise(n, 0.0, l2, d, false);
            graphicsContext.strokeLine(d3, 20.0, d3, 20.0 + d2);
            boolean bl = n > 0 && n < 5000;
            graphicsContext.strokeText(StringUtil.formatTimestamp(n, bl), d3, 20.0 + d2 + 12.0);
            n = (int)((long)n + l3);
        }
    }

    private void drawYAxis(GraphicsContext graphicsContext, int n, double d, double d2) {
        int n2 = this.getYStep(n);
        for (int i = 0; i < n; i += n2) {
            double d3 = 20.0 + this.normalise(i, 0.0, n, d2, true);
            graphicsContext.strokeLine(60.0, d3, 60.0 + d, d3);
            graphicsContext.strokeText(Integer.toString(i), 2.0, d3 + 2.0);
        }
    }

    private long getXStep(long l, long l2) {
        long l3 = l2 - l;
        int n = 6;
        long[] lArray = new long[]{0x6DDD00L, 3600000L, 1800000L, 900000L, 600000L, 300000L, 120000L, 60000L, 30000L, 15000L, 10000L, 5000L, 2000L, 1000L, 500L, 200L, 100L, 50L, 20L, 10L, 5L, 2L, 1L};
        long l4 = 0x6DDD00L;
        for (int i = 0; i < lArray.length; ++i) {
            if (l3 / lArray[i] < (long)n) continue;
            l4 = lArray[i];
            break;
        }
        return l4;
    }

    private int getYStep(int n) {
        int n2 = 10;
        for (int i = 0; i < Y_SCALE.length; ++i) {
            if (n / Y_SCALE[i] >= n2) continue;
            return Y_SCALE[i];
        }
        return n / n2;
    }

    private double normalise(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = d3 - d2;
        double d6 = 0.0;
        d6 = d5 == 0.0 ? 0.0 : (d - d2) / d5;
        d6 *= d4;
        if (bl) {
            d6 = d4 - d6;
        }
        return d6;
    }

    static {
        int n = 1;
        for (int i = 0; i < Y_SCALE.length; i += 3) {
            TimeLineStage.Y_SCALE[i + 0] = 1 * n;
            TimeLineStage.Y_SCALE[i + 1] = 2 * n;
            TimeLineStage.Y_SCALE[i + 2] = 5 * n;
            n *= 10;
        }
    }
}

