/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.ui;

import com.chrisnewland.jitwatch.model.PackageManager;
import com.chrisnewland.jitwatch.toplist.MemberScore;
import com.chrisnewland.jitwatch.toplist.ToplistTreeWalker;
import com.chrisnewland.jitwatch.ui.JITWatchUI;
import com.chrisnewland.jitwatch.ui.TableUtil;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class TopListStage
extends Stage {
    private ObservableList<MemberScore> topList = FXCollections.observableArrayList();
    private TableView<MemberScore> tableView;
    private String selectedAttribute;
    private PackageManager pm;

    public TopListStage(final JITWatchUI jITWatchUI) {
        this.initStyle(StageStyle.DECORATED);
        this.pm = jITWatchUI.getPackageManager();
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                jITWatchUI.handleStageClosed(TopListStage.this);
            }
        });
        int n = 640;
        int n2 = 480;
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Largest Native Methods", "nmsize");
        hashMap.put("Largest Bytecode Methods", "bytes");
        hashMap.put("Slowest Compilation Times", "compileMillis");
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(8.0));
        vBox.setSpacing(8.0);
        ObservableList observableList = FXCollections.observableArrayList(hashMap.keySet());
        this.selectedAttribute = (String)hashMap.get(observableList.get(0));
        ComboBox comboBox = new ComboBox(observableList);
        comboBox.setValue(observableList.get(0));
        comboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                TopListStage.this.selectedAttribute = (String)hashMap.get(string2);
                TopListStage.this.buildTableView(TopListStage.this.selectedAttribute);
            }
        });
        Scene scene = new Scene((Parent)vBox, (double)n, (double)n2);
        this.setTitle("JITWatch TopLists");
        this.buildTableView(this.selectedAttribute);
        this.tableView = TableUtil.buildTableMemberScore(this.topList);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<MemberScore>(){

            public void changed(ObservableValue<? extends MemberScore> observableValue, MemberScore memberScore, MemberScore memberScore2) {
                if (memberScore2 != null) {
                    jITWatchUI.openTreeAtMember(memberScore2.getMember());
                }
            }
        });
        vBox.getChildren().add((Object)comboBox);
        vBox.getChildren().add(this.tableView);
        this.tableView.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        this.setScene(scene);
        this.show();
        this.redraw();
    }

    private void buildTableView(String string) {
        this.topList.clear();
        this.topList.addAll(ToplistTreeWalker.buildTopListForAttribute(this.pm, true, this.selectedAttribute));
    }

    public void redraw() {
    }
}

