/*
 * Decompiled with CFR 0.152.
 */
package com.chrisnewland.jitwatch.util;

import com.chrisnewland.jitwatch.util.ClassUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseUtil {
    private static final Pattern PATTERN_LOG_SIGNATURE = Pattern.compile("^([0-9a-zA-Z\\.\\$_]+) ([0-9a-zA-Z<>_\\$]+) (\\(.*\\))(.*)");

    public static Class<?> getPrimitiveClass(char c) {
        switch (c) {
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
        }
        throw new RuntimeException("Unknown class for " + c);
    }

    public static String expandParameterType(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block12: for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            switch (n) {
                case 91: {
                    ++n2;
                    continue block12;
                }
                case 83: {
                    stringBuilder.append("short");
                    continue block12;
                }
                case 67: {
                    stringBuilder.append("char");
                    continue block12;
                }
                case 66: {
                    stringBuilder.append("byte");
                    continue block12;
                }
                case 74: {
                    stringBuilder.append("long");
                    continue block12;
                }
                case 68: {
                    stringBuilder.append("double");
                    continue block12;
                }
                case 90: {
                    stringBuilder.append("boolean");
                    continue block12;
                }
                case 73: {
                    stringBuilder.append("int");
                    continue block12;
                }
                case 70: {
                    stringBuilder.append("float");
                    continue block12;
                }
                case 59: {
                    continue block12;
                }
                default: {
                    if (string.charAt(i) == 'L' && string.endsWith(";")) {
                        stringBuilder.append(string.substring(i + 1, string.length() - 1));
                        break block12;
                    }
                    stringBuilder.append(string.substring(i));
                    break block12;
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public static String[] parseLogSignature(String string) throws Exception {
        String[] stringArray = null;
        Matcher matcher = PATTERN_LOG_SIGNATURE.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3).replace("(", "").replace(")", "");
            String string5 = matcher.group(4);
            Class<?>[] classArray = ParseUtil.getClassTypes(string4);
            Class<?>[] classArray2 = ParseUtil.getClassTypes(string5);
            Class clazz = classArray2.length == 0 ? Void.class : classArray2[0];
            String string6 = ParseUtil.buildMethodSignature(string2, string3, classArray, clazz);
            stringArray = new String[]{string2, string6};
        }
        return stringArray;
    }

    public static String buildMethodSignature(String string, String string2, Class<?>[] classArray, Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = clazz.getName();
        string3 = ParseUtil.expandParameterType(string3);
        if ("<init>".equals(string2)) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(string3).append(" ").append(string).append(".").append(string2);
        }
        stringBuilder.append("(");
        for (Class<?> clazz2 : classArray) {
            String string4 = clazz2.getName();
            string4 = ParseUtil.expandParameterType(string4);
            stringBuilder.append(string4).append(",");
        }
        if (classArray.length > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(")");
        String string5 = stringBuilder.toString();
        return string5;
    }

    /*
     * Unable to fully structure code
     */
    public static Class<?>[] getClassTypes(String var0) throws Exception {
        block14: {
            var1_1 = new ArrayList<Class<?>>();
            var2_2 = var0.length();
            if (var2_2 <= 0) break block14;
            var3_3 = new StringBuilder();
            try {
                var4_4 = 0;
                block9: while (var4_4 < var0.length()) {
                    var5_9 = var0.charAt(var4_4);
                    switch (var5_9) {
                        case '[': {
                            var3_3.delete(0, var3_3.length());
                            var3_3.append(var5_9);
                            var5_9 = var0.charAt(++var4_4);
                            while (var5_9 == '[') {
                                var3_3.append(var5_9);
                                var5_9 = var0.charAt(++var4_4);
                            }
                            if (var5_9 != 'L') ** GOTO lbl29
                            while (var4_4 < var2_2) {
                                var5_9 = var0.charAt(var4_4++);
                                var3_3.append(var5_9);
                                if (var5_9 != ';') continue;
                                ** GOTO lbl32
                            }
                            ** GOTO lbl32
lbl29:
                            // 1 sources

                            var3_3.append(var5_9);
                            ++var4_4;
lbl32:
                            // 3 sources

                            var6_10 = ClassUtil.loadClassWithoutInitialising(var3_3.toString());
                            var1_1.add(var6_10);
                            var3_3.delete(0, var3_3.length());
                            continue block9;
                        }
                        case 'L': {
                            while (var4_4 < var2_2) {
                                if ((var5_9 = var0.charAt(++var4_4)) == ';') {
                                    ++var4_4;
                                    break;
                                }
                                var3_3.append(var5_9);
                            }
                            var7_11 = ClassUtil.loadClassWithoutInitialising(var3_3.toString());
                            var1_1.add(var7_11);
                            var3_3.delete(0, var3_3.length());
                            continue block9;
                        }
                    }
                    var8_12 = ParseUtil.getPrimitiveClass(var5_9);
                    var1_1.add(var8_12);
                    ++var4_4;
                }
            }
            catch (ClassNotFoundException var4_5) {
                throw new Exception("ClassNotFoundException: " + var3_3.toString());
            }
            catch (NoClassDefFoundError var4_6) {
                throw new Exception("NoClassDefFoundError: " + var3_3.toString());
            }
            catch (Exception var4_7) {
                throw new Exception("Exception: " + var4_7.getMessage());
            }
            catch (Error var4_8) {
                throw new Exception("Error: " + var4_8.getMessage());
            }
        }
        return var1_1.toArray(new Class[var1_1.size()]);
    }
}

